<?php

use Illuminate\Support\Facades\Storage;

// Workaround for php artisan serve not following symlinks on Windows
Route::get('/storage/{path}', function ($path) {
    if (!Storage::disk('public')->exists($path)) {
        abort(404);
    }
    return Storage::disk('public')->response($path);
})->where('path', '.*')->name('storage.serve');

use App\Livewire\Home;
use App\Livewire\Cars\Index as CarsIndex;
use App\Livewire\Cars\Show as CarShow;
use App\Livewire\Motors\Index as MotorsIndex;
use App\Livewire\Motors\Show as MotorShow;
use App\Livewire\Tours\Index as ToursIndex;
use App\Livewire\Tours\Show as TourShow;

Route::get('/', Home::class)->name('home');
Route::get('/cars', CarsIndex::class)->name('cars.index');
Route::get('/car/{car}', CarShow::class)->name('cars.show');
Route::get('/motors', MotorsIndex::class)->name('motors.index');
Route::get('/motor/{motor}', MotorShow::class)->name('motors.show');
Route::get('/tours', ToursIndex::class)->name('tours.index');
Route::get('/tour/{tour}', TourShow::class)->name('tours.show');
Route::get('/article/{article:slug}', \App\Livewire\Articles\Show::class)->name('articles.show');

Route::view('dashboard', 'dashboard')
    ->middleware(['auth', 'verified'])
    ->name('dashboard');

Route::view('profile', 'profile')
    ->middleware(['auth'])
    ->name('profile');

Route::middleware(['auth', 'role:admin'])->prefix('admin')->name('admin.')->group(function () {
    Route::get('/dashboard', \App\Livewire\Admin\Dashboard::class)->name('dashboard');
    Route::get('/settings', \App\Livewire\Admin\Settings::class)->middleware('role:superadmin')->name('settings');
    Route::get('/users', \App\Livewire\Admin\Users\Index::class)->middleware('role:superadmin')->name('users.index');
    Route::get('/users/create', \App\Livewire\Admin\Users\Create::class)->middleware('role:superadmin')->name('users.create');
    Route::get('/users/{user}/edit', \App\Livewire\Admin\Users\Edit::class)->middleware('role:superadmin')->name('users.edit');

    // Cars CRUD
    Route::get('/cars', \App\Livewire\Admin\Cars\Index::class)->name('cars.index');
    Route::get('/cars/create', \App\Livewire\Admin\Cars\Create::class)->name('cars.create');
    Route::get('/cars/{car}/edit', \App\Livewire\Admin\Cars\Edit::class)->name('cars.edit');

    // Motors CRUD
    Route::get('/motors', \App\Livewire\Admin\Motors\Index::class)->name('motors.index');
    Route::get('/motors/create', \App\Livewire\Admin\Motors\Create::class)->name('motors.create');
    Route::get('/motors/{motor}/edit', \App\Livewire\Admin\Motors\Edit::class)->name('motors.edit');

    // Tours CRUD
    Route::get('/tours', \App\Livewire\Admin\Tours\Index::class)->name('tours.index');
    Route::get('/tours/create', \App\Livewire\Admin\Tours\Create::class)->name('tours.create');
    Route::get('/tours/{tour}/edit', \App\Livewire\Admin\Tours\Edit::class)->name('tours.edit');

    // Brands Management
    Route::get('/brands', \App\Livewire\Admin\Brands::class)->name('brands');

    // Articles CRUD
    Route::get('/articles', \App\Livewire\Admin\Articles\Index::class)->name('articles.index');
    Route::get('/articles/create', \App\Livewire\Admin\Articles\Create::class)->name('articles.create');
    Route::get('/articles/{article}/edit', \App\Livewire\Admin\Articles\Edit::class)->name('articles.edit');
});

Route::get('/track-click', [\App\Http\Controllers\TrackingController::class, 'trackClick'])->name('track.click');

require __DIR__.'/auth.php';
