<div class="bg-slate-50 min-h-screen pt-24 pb-12">
    <div class="container mx-auto px-6">
        <div class="flex flex-col items-center text-center mb-10">
            <span class="text-sm font-bold text-[#dc8034] uppercase tracking-widest mb-2">Explore Paradise</span>
            <h1 class="text-3xl md:text-4xl font-extrabold text-[#2b6497] mb-4">Tour Packages</h1>
            <div class="w-16 h-1 bg-[#dc8034] rounded-full mb-6"></div>
            <p class="text-neutral-500 text-lg max-w-2xl">
                Discover the beauty of our island with curated tour packages. From beaches to mountains, we have it all.
            </p>
        </div>

        <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-3 gap-4 md:gap-8 items-stretch">
            @forelse($tours as $tour)
                @php
                    $imageSrc = $tour->main_image;
                    if (!str_starts_with($imageSrc, 'http')) {
                        $imageSrc = asset('storage/' . $imageSrc);
                    }
                @endphp
                <div class="bg-white rounded-2xl shadow-sm border border-slate-100 overflow-hidden group hover:shadow-lg transition-all duration-300 hover:-translate-y-1 h-full flex flex-col">
                    <div class="relative aspect-4/3 overflow-hidden shrink-0">
                        <img 
                            src="{{ $imageSrc }}" 
                            alt="{{ $tour->name }}" 
                            class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-700 aspect-4/3"
                            onerror="this.onerror=null; this.src='https://images.unsplash.com/photo-1537996194471-e657df975ab4?w=800&h=600&fit=crop'; this.classList.add('opacity-70');"
                        >
                        <div class="absolute top-5 left-5">
                            <span class="px-3 py-1 bg-white/90 backdrop-blur text-[#2b6497] text-xs font-bold rounded-full shadow-sm">
                                {{ $tour->category }}
                            </span>
                        </div>
                        <div class="absolute bottom-5 left-5">
                            <span class="px-3 py-1 bg-black/60 backdrop-blur text-white text-xs font-bold rounded-full flex items-center gap-1">
                                <i class="fa-regular fa-clock"></i>
                                {{ $tour->duration }}
                            </span>
                        </div>
                    </div>
                    
                    <div class="p-5 flex flex-col grow">
                        <div class="flex items-center justify-between mb-2">
                             <div class="flex items-center gap-1 text-yellow-500 text-sm">
                                <i class="fa-solid fa-star"></i>
                                <span class="text-slate-600 font-medium">5.0</span>
                            </div>
                            <span class="text-xs font-semibold text-slate-500 bg-slate-100 px-2 py-1 rounded">
                                {{ $tour->difficulty }}
                            </span>
                        </div>

                        <h3 class="text-lg font-bold text-slate-800 mb-2 line-clamp-1 group-hover:text-[#dc8034] transition-colors">
                            <a href="{{ route('tours.show', $tour) }}">
                                {{ $tour->name }}
                            </a>
                        </h3>
                        
                        <p class="text-slate-500 text-sm mb-4 line-clamp-2 grow">
                            {{ $tour->description }}
                        </p>

                        <div class="flex items-center justify-between pt-4 border-t border-slate-100 mt-auto">
                            <div>
                                <span class="text-xs text-slate-400 uppercase tracking-wide">Starting from</span>
                                <div class="text-[#2b6497] font-bold text-lg">
                                    Rp {{ number_format($tour->price, 0, ',', '.') }}
                                </div>
                            </div>
                            
                            <a href="{{ route('tours.show', $tour) }}" class="inline-flex items-center justify-center w-10 h-10 rounded-full bg-slate-50 text-[#dc8034] hover:bg-[#dc8034] hover:text-white transition-all">
                                <i class="fa-solid fa-arrow-right"></i>
                            </a>
                        </div>
                    </div>
                </div>
            @empty
                <div class="col-span-full text-center py-20">
                    <div class="inline-flex items-center justify-center w-20 h-20 bg-slate-100 rounded-full mb-4">
                        <i class="fa-regular fa-map text-4xl text-slate-400"></i>
                    </div>
                    <h3 class="text-xl font-bold text-slate-800 mb-2">No Tours Available Yet</h3>
                    <p class="text-slate-500">We are currently curating the best experiences for you. Check back soon!</p>
                </div>
            @endforelse
        </div>

        <div class="mt-12">
            {{ $tours->links() }}
        </div>
    </div>
</div>
