<div class="space-y-6">
    {{-- Header --}}
    <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
        <div>
            <h2 class="text-2xl font-bold tracking-tight text-slate-800">Manage Tours</h2>
            <p class="text-sm text-slate-500 mt-1">Add, edit, or remove tour packages.</p>
        </div>
        <a href="{{ route('admin.tours.create') }}" class="inline-flex items-center px-4 py-2 bg-[#dc8034] text-white font-semibold rounded-lg shadow hover:bg-[#c06d28] transition-colors">
            <i class="fa-solid fa-plus mr-2"></i>
            Add New Tour
        </a>
    </div>

    {{-- Flash Message --}}
    @if(session('success'))
        <div class="bg-emerald-50 border border-emerald-200 text-emerald-700 px-4 py-3 rounded-lg flex items-center">
            <i class="fa-solid fa-circle-check mr-2"></i>
            {{ session('success') }}
        </div>
    @endif

    {{-- Search --}}
    <div class="bg-white rounded-xl border border-slate-200 shadow-sm p-4">
        <div class="relative flex-1">
            <i class="fa-solid fa-search absolute left-3 top-1/2 -translate-y-1/2 text-slate-400"></i>
            <input 
                type="text" 
                wire:model.live.debounce.300ms="search" 
                placeholder="Search tours..." 
                class="w-full pl-10 pr-4 py-2 border border-slate-300 rounded-lg focus:ring-[#dc8034] focus:border-[#dc8034]"
            >
        </div>
    </div>

    {{-- Table --}}
    <div class="bg-white rounded-xl border border-slate-200 shadow-sm overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-slate-200">
                <thead class="bg-slate-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-semibold text-slate-500 uppercase tracking-wider">Image</th>
                        <th wire:click="sortBy('name')" class="px-6 py-3 text-left text-xs font-semibold text-slate-500 uppercase tracking-wider cursor-pointer hover:text-slate-700">
                            Tour Name
                            @if($sortField === 'name')
                                <i class="fa-solid fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }} ml-1"></i>
                            @endif
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-semibold text-slate-500 uppercase tracking-wider">Duration</th>
                        <th wire:click="sortBy('price')" class="px-6 py-3 text-left text-xs font-semibold text-slate-500 uppercase tracking-wider cursor-pointer hover:text-slate-700">
                            Price
                            @if($sortField === 'price')
                                <i class="fa-solid fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }} ml-1"></i>
                            @endif
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-semibold text-slate-500 uppercase tracking-wider">Status</th>
                        <th class="px-6 py-3 text-right text-xs font-semibold text-slate-500 uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-slate-200">
                    @forelse($tours as $tour)
                        <tr class="hover:bg-slate-50 transition-colors">
                            <td class="px-6 py-4 whitespace-nowrap">
                                <img src="{{ asset('storage/' . $tour->main_image) }}" alt="{{ $tour->name }}" class="w-16 h-12 object-cover rounded-lg border">
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="font-medium text-slate-900">{{ $tour->name }}</div>
                                <div class="text-xs text-slate-500">{{ $tour->category }} • {{ $tour->difficulty }}</div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-slate-600">
                                {{ $tour->duration }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-slate-900 font-semibold">
                                Rp {{ number_format($tour->price, 0, ',', '.') }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                @if($tour->status === 'active')
                                    <span class="px-2.5 py-1 text-xs font-semibold rounded-full bg-emerald-100 text-emerald-700">Active</span>
                                @else
                                    <span class="px-2.5 py-1 text-xs font-semibold rounded-full bg-slate-100 text-slate-600">Inactive</span>
                                @endif
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                <a href="{{ route('admin.tours.edit', $tour) }}" class="text-blue-600 hover:text-blue-800 mr-3">
                                    <i class="fa-solid fa-pen-to-square"></i> Edit
                                </a>
                                <button wire:click="delete({{ $tour->id }})" wire:confirm="Are you sure you want to delete this tour?" class="text-red-600 hover:text-red-800">
                                    <i class="fa-solid fa-trash"></i> Delete
                                </button>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="px-6 py-12 text-center text-slate-400">
                                <i class="fa-solid fa-map-location-dot text-4xl mb-3 opacity-50"></i>
                                <p>No tours found. Add your first tour package!</p>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        @if($tours->hasPages())
            <div class="px-6 py-4 border-t border-slate-200">
                {{ $tours->links() }}
            </div>
        @endif
    </div>
</div>
