<div class="space-y-6">
    {{-- Header --}}
    <div class="flex items-center justify-between">
        <div>
            <a href="{{ route('admin.tours.index') }}" class="text-sm text-slate-500 hover:text-slate-700 mb-2 inline-flex items-center">
                <i class="fa-solid fa-arrow-left mr-2"></i> Back to Tours
            </a>
            <h2 class="text-2xl font-bold tracking-tight text-slate-800">Edit Tour: {{ $tour->name }}</h2>
        </div>
    </div>

    {{-- Form --}}
    <form wire:submit="save" class="bg-white rounded-xl border border-slate-200 shadow-sm overflow-hidden">
        <div class="p-6 space-y-6">
             {{-- Basic Info --}}
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div class="md:col-span-2">
                    <label class="block text-sm font-medium text-slate-700 mb-1.5">Tour Name *</label>
                     <div class="relative">
                        <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                            <i class="fa-solid fa-map-location text-slate-400"></i>
                        </div>
                        <input type="text" wire:model="name" class="block w-full rounded-lg border-0 py-2.5 pl-10 text-slate-900 ring-1 ring-inset ring-slate-300 placeholder:text-slate-400 focus:ring-2 focus:ring-inset focus:ring-[#dc8034] sm:text-sm sm:leading-6" placeholder="e.g. 3 Days Explore Lombok">
                    </div>
                    @error('name') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-slate-700 mb-1.5">Duration *</label>
                     <div class="relative">
                        <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                            <i class="fa-solid fa-clock text-slate-400"></i>
                        </div>
                        <input type="text" wire:model="duration" class="block w-full rounded-lg border-0 py-2.5 pl-10 text-slate-900 ring-1 ring-inset ring-slate-300 placeholder:text-slate-400 focus:ring-2 focus:ring-inset focus:ring-[#dc8034] sm:text-sm sm:leading-6" placeholder="e.g. 3 Days 2 Nights">
                    </div>
                    @error('duration') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-slate-700 mb-1.5">Category *</label>
                     <div class="relative">
                        <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                            <i class="fa-solid fa-list-ul text-slate-400"></i>
                        </div>
                        <select wire:model="category" class="block w-full rounded-lg border-0 py-2.5 pl-10 text-slate-900 ring-1 ring-inset ring-slate-300 placeholder:text-slate-400 focus:ring-2 focus:ring-inset focus:ring-[#dc8034] sm:text-sm sm:leading-6">
                            <option value="Nature">Nature</option>
                            <option value="Culture">Culture</option>
                            <option value="Adventure">Adventure</option>
                            <option value="City">City</option>
                        </select>
                    </div>
                    @error('category') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-slate-700 mb-1.5">Difficulty *</label>
                     <div class="relative">
                        <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                            <i class="fa-solid fa-person-hiking text-slate-400"></i>
                        </div>
                        <select wire:model="difficulty" class="block w-full rounded-lg border-0 py-2.5 pl-10 text-slate-900 ring-1 ring-inset ring-slate-300 placeholder:text-slate-400 focus:ring-2 focus:ring-inset focus:ring-[#dc8034] sm:text-sm sm:leading-6">
                            <option value="Easy">Easy</option>
                            <option value="Medium">Medium</option>
                            <option value="Hard">Hard</option>
                        </select>
                    </div>
                    @error('difficulty') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-slate-700 mb-1.5">Max People *</label>
                     <div class="relative">
                        <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                            <i class="fa-solid fa-users text-slate-400"></i>
                        </div>
                        <input type="number" wire:model="max_people" class="block w-full rounded-lg border-0 py-2.5 pl-10 text-slate-900 ring-1 ring-inset ring-slate-300 placeholder:text-slate-400 focus:ring-2 focus:ring-inset focus:ring-[#dc8034] sm:text-sm sm:leading-6" placeholder="10">
                    </div>
                    @error('max_people') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                </div>

                 <div>
                    <label class="block text-sm font-medium text-slate-700 mb-1.5">Status *</label>
                     <div class="relative">
                        <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                            <i class="fa-solid fa-circle-info text-slate-400"></i>
                        </div>
                        <select wire:model="status" class="block w-full rounded-lg border-0 py-2.5 pl-10 text-slate-900 ring-1 ring-inset ring-slate-300 placeholder:text-slate-400 focus:ring-2 focus:ring-inset focus:ring-[#dc8034] sm:text-sm sm:leading-6">
                            <option value="active">Active</option>
                            <option value="inactive">Inactive</option>
                        </select>
                    </div>
                    @error('status') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                </div>
            </div>

            {{-- Description --}}
            <div>
                <label class="block text-sm font-medium text-slate-700 mb-1.5">Description *</label>
                 <div class="relative">
                    <div class="absolute top-3 left-3 pointer-events-none">
                        <i class="fa-solid fa-align-left text-slate-400"></i>
                    </div>
                    <textarea wire:model="description" rows="5" class="block w-full rounded-lg border-0 py-2.5 pl-10 text-slate-900 ring-1 ring-inset ring-slate-300 placeholder:text-slate-400 focus:ring-2 focus:ring-inset focus:ring-[#dc8034] sm:text-sm sm:leading-6" placeholder="Describe the tour itinerary and highlights..."></textarea>
                </div>
                @error('description') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
            </div>

            {{-- Pricing --}}
            <div class="border-t border-slate-100 pt-6">
                <h3 class="text-lg font-semibold text-slate-800 mb-4">Pricing</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label class="block text-sm font-medium text-slate-700 mb-1.5">Price per Person (Rp) *</label>
                         <div class="relative">
                             <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                                <span class="text-slate-400 font-semibold text-xs">Rp</span>
                            </div>
                            <input type="number" wire:model="price" class="block w-full rounded-lg border-0 py-2.5 pl-10 text-slate-900 ring-1 ring-inset ring-slate-300 placeholder:text-slate-400 focus:ring-2 focus:ring-inset focus:ring-[#dc8034] sm:text-sm sm:leading-6" placeholder="500000">
                        </div>
                        @error('price') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-slate-700 mb-1.5">Price with Motorbike (Rp)</label>
                         <div class="relative">
                             <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                                <span class="text-slate-400 font-semibold text-xs">Rp</span>
                            </div>
                            <input type="number" wire:model="price_motor" class="block w-full rounded-lg border-0 py-2.5 pl-10 text-slate-900 ring-1 ring-inset ring-slate-300 placeholder:text-slate-400 focus:ring-2 focus:ring-inset focus:ring-[#dc8034] sm:text-sm sm:leading-6" placeholder="750000">
                        </div>
                        @error('price_motor') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                    </div>
                </div>
            </div>

            {{-- Image Upload --}}
            <div class="border-t border-slate-100 pt-6">
                <h3 class="text-lg font-semibold text-slate-800 mb-4">Main Image</h3>
                <div class="flex flex-col items-start gap-4">
                     <div class="relative group w-full max-w-[240px] aspect-video bg-slate-50 rounded-xl border-2 border-dashed border-slate-300 hover:border-[#dc8034] hover:bg-[#dc8034]/5 transition-all duration-300 flex flex-col items-center justify-center cursor-pointer overflow-hidden">
                        @if($new_main_image)
                            <img src="{{ $new_main_image->temporaryUrl() }}" class="absolute inset-0 w-full h-full object-cover p-2 rounded-xl z-10">
                            <div class="absolute inset-0 bg-black/50 opacity-0 group-hover:opacity-100 transition-opacity z-20 flex items-center justify-center">
                                <span class="text-white font-medium text-sm">Click to Change</span>
                            </div>
                        @else
                            <img src="{{ asset('storage/' . $tour->main_image) }}" class="absolute inset-0 w-full h-full object-cover p-2 rounded-xl z-10">
                            <div class="absolute inset-0 bg-black/50 opacity-0 group-hover:opacity-100 transition-opacity z-20 flex items-center justify-center">
                                <span class="text-white font-medium text-sm">Click to Change</span>
                            </div>
                        @endif
                        
                        <input type="file" wire:model="new_main_image" accept="image/*" class="absolute inset-0 w-full h-full opacity-0 cursor-pointer z-30">
                        
                         {{-- Loading --}}
                        <div wire:loading wire:target="new_main_image" class="absolute inset-0 bg-white/90 z-40 flex items-center justify-center">
                            <div class="flex flex-col items-center">
                                <i class="fa-solid fa-spinner fa-spin text-2xl text-[#dc8034] mb-2"></i>
                                <span class="text-xs font-semibold text-[#dc8034]">Uploading...</span>
                            </div>
                        </div>
                    </div>
                    <p class="text-xs text-slate-500">Leave empty to keep current image. Max 2MB.</p>
                     @error('new_main_image') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                </div>
            </div>

            {{-- Gallery Images --}}
            <div class="border-t border-slate-100 pt-6">
                <h3 class="text-lg font-semibold text-slate-800 mb-4">Gallery Images</h3>
                
                {{-- Existing Images --}}
                @if(count($images) > 0)
                    <div class="mb-4">
                        <label class="block text-sm font-medium text-slate-700 mb-2">Current Images</label>
                        <div class="grid grid-cols-2 md:grid-cols-4 lg:grid-cols-6 gap-4">
                            @foreach($images as $index => $image)
                                <div class="relative aspect-video bg-slate-100 rounded-lg overflow-hidden border border-slate-200 group">
                                    <img src="{{ asset('storage/' . $image) }}" class="w-full h-full object-cover">
                                    <div class="absolute inset-0 bg-black/50 opacity-0 group-hover:opacity-100 transition-opacity flex items-center justify-center">
                                        <button type="button" wire:click="removeImage({{ $index }})" wire:confirm="Remove this image?" class="bg-red-500 text-white p-2 rounded-full hover:bg-red-600 transition-colors shadow-sm">
                                            <i class="fa-solid fa-trash text-sm"></i>
                                        </button>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                @endif

                <div class="space-y-4">
                    <label class="block text-sm font-medium text-slate-700 mb-1.5">Add New Images</label>
                    <div class="relative group w-full min-h-[120px] bg-slate-50 rounded-xl border-2 border-dashed border-slate-300 hover:border-[#dc8034] hover:bg-[#dc8034]/5 transition-all duration-300 flex flex-col items-center justify-center cursor-pointer">
                        <div class="flex flex-col items-center justify-center p-6 text-center">
                            <i class="fa-solid fa-images text-slate-400 text-2xl mb-2 group-hover:text-[#dc8034] transition-colors"></i>
                            <p class="text-sm font-medium text-slate-700">Drop images here</p>
                            <p class="text-xs text-slate-500 mt-1">Upload multiple images</p>
                        </div>
                        <input type="file" wire:model="new_images" multiple accept="image/*" class="absolute inset-0 w-full h-full opacity-0 cursor-pointer z-10">
                        
                         {{-- Loading --}}
                        <div wire:loading wire:target="new_images" class="absolute inset-0 bg-white/90 z-20 flex items-center justify-center rounded-xl">
                            <div class="flex items-center gap-2">
                                <i class="fa-solid fa-spinner fa-spin text-[#dc8034]"></i>
                                <span class="text-xs font-semibold text-[#dc8034]">Processing...</span>
                            </div>
                        </div>
                    </div>
                    @error('new_images.*') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror

                    {{-- Previews --}}
                    @if($new_images)
                        <div class="grid grid-cols-2 md:grid-cols-4 lg:grid-cols-6 gap-4">
                            @foreach($new_images as $image)
                                <div class="relative aspect-video bg-slate-100 rounded-lg overflow-hidden border border-slate-200">
                                    <img src="{{ $image->temporaryUrl() }}" class="w-full h-full object-cover">
                                    <div class="absolute inset-0 bg-black/50 opacity-0 hover:opacity-100 transition-opacity flex items-center justify-center">
                                         <span class="text-white text-xs font-medium">New</span>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    @endif
                </div>
            </div>
        </div>

        {{-- Footer --}}
        <div class="px-6 py-4 bg-slate-50 border-t border-slate-200 flex justify-end gap-3">
            <a href="{{ route('admin.tours.index') }}" class="px-4 py-2 border border-slate-300 text-slate-700 rounded-lg hover:bg-slate-100 transition-colors">
                Cancel
            </a>
            <button type="submit" class="px-6 py-2 bg-[#dc8034] text-white font-semibold rounded-lg hover:bg-[#c06d28] transition-colors shadow-lg shadow-[#dc8034]/20">
                <i class="fa-solid fa-save mr-2"></i> Update Tour
            </button>
        </div>
    </form>
</div>
