<div class="space-y-6">
    {{-- Header --}}
    <div class="flex flex-col sm:flex-row sm:items-center sm:justify-between gap-4">
        <div>
            <h2 class="text-2xl font-bold tracking-tight text-slate-800">Manage Cars</h2>
            <p class="text-sm text-slate-500 mt-1">Add, edit, or remove cars from your fleet.</p>
        </div>
        <a href="{{ route('admin.cars.create') }}" class="inline-flex items-center px-4 py-2 bg-[#dc8034] text-white font-semibold rounded-lg shadow hover:bg-[#c06d28] transition-colors">
            <i class="fa-solid fa-plus mr-2"></i>
            Add New Car
        </a>
    </div>

    {{-- Flash Message --}}
    @if(session('success'))
        <div class="bg-emerald-50 border border-emerald-200 text-emerald-700 px-4 py-3 rounded-lg flex items-center">
            <i class="fa-solid fa-circle-check mr-2"></i>
            {{ session('success') }}
        </div>
    @endif

    {{-- Search & Filters --}}
    <div class="bg-white rounded-xl border border-slate-200 shadow-sm p-4">
        <div class="flex flex-col sm:flex-row sm:items-center gap-4">
            <div class="relative flex-1">
                <i class="fa-solid fa-search absolute left-3 top-1/2 -translate-y-1/2 text-slate-400"></i>
                <input 
                    type="text" 
                    wire:model.live.debounce.300ms="search" 
                    placeholder="Search cars by name..." 
                    class="w-full pl-10 pr-4 py-2 border border-slate-300 rounded-lg focus:ring-[#dc8034] focus:border-[#dc8034]"
                >
            </div>
        </div>
    </div>

    {{-- Table --}}
    <div class="bg-white rounded-xl border border-slate-200 shadow-sm overflow-hidden">
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-slate-200">
                <thead class="bg-slate-50">
                    <tr>
                        <th class="px-6 py-3 text-left text-xs font-semibold text-slate-500 uppercase tracking-wider">Image</th>
                        <th wire:click="sortBy('name')" class="px-6 py-3 text-left text-xs font-semibold text-slate-500 uppercase tracking-wider cursor-pointer hover:text-slate-700">
                            Name
                            @if($sortField === 'name')
                                <i class="fa-solid fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }} ml-1"></i>
                            @endif
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-semibold text-slate-500 uppercase tracking-wider">Brand</th>
                        <th wire:click="sortBy('price_daily')" class="px-6 py-3 text-left text-xs font-semibold text-slate-500 uppercase tracking-wider cursor-pointer hover:text-slate-700">
                            Price/Day
                            @if($sortField === 'price_daily')
                                <i class="fa-solid fa-sort-{{ $sortDirection === 'asc' ? 'up' : 'down' }} ml-1"></i>
                            @endif
                        </th>
                        <th class="px-6 py-3 text-left text-xs font-semibold text-slate-500 uppercase tracking-wider">Status</th>
                        <th class="px-6 py-3 text-right text-xs font-semibold text-slate-500 uppercase tracking-wider">Actions</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-slate-200">
                    @forelse($cars as $car)
                        <tr class="hover:bg-slate-50 transition-colors">
                            <td class="px-6 py-4 whitespace-nowrap">
                                <img src="{{ asset('storage/' . $car->main_image) }}" alt="{{ $car->name }}" class="w-16 h-12 object-cover rounded-lg border">
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                <div class="font-medium text-slate-900">{{ $car->name }}</div>
                                <div class="text-xs text-slate-500">{{ $car->year }} • {{ $car->transmission }}</div>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-slate-600">
                                {{ $car->brand->name ?? '-' }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-slate-900 font-semibold">
                                Rp {{ number_format($car->price_daily, 0, ',', '.') }}
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap">
                                @php
                                    $statusClasses = [
                                        'available' => 'bg-emerald-100 text-emerald-700 hover:bg-emerald-200',
                                        'booked' => 'bg-amber-100 text-amber-700 hover:bg-amber-200',
                                        'maintenance' => 'bg-slate-100 text-slate-600 hover:bg-slate-200',
                                    ];
                                    $currentClass = $statusClasses[$car->status] ?? $statusClasses['maintenance'];
                                @endphp
                                <select 
                                    wire:change="updateStatus({{ $car->id }}, $event.target.value)"
                                    class="text-xs font-semibold rounded-full py-1.5 pl-3 pr-8 border-0 cursor-pointer transition-colors {{ $currentClass }}"
                                >
                                    <option value="available" @selected($car->status === 'available')>Available</option>
                                    <option value="booked" @selected($car->status === 'booked')>Booked</option>
                                    <option value="maintenance" @selected($car->status === 'maintenance')>Maintenance</option>
                                </select>
                            </td>
                            <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                                <a href="{{ route('admin.cars.edit', $car) }}" class="text-blue-600 hover:text-blue-800 mr-3">
                                    <i class="fa-solid fa-pen-to-square"></i> Edit
                                </a>
                                <button wire:click="delete({{ $car->id }})" wire:confirm="Are you sure you want to delete this car?" class="text-red-600 hover:text-red-800">
                                    <i class="fa-solid fa-trash"></i> Delete
                                </button>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="6" class="px-6 py-12 text-center text-slate-400">
                                <i class="fa-solid fa-car text-4xl mb-3 opacity-50"></i>
                                <p>No cars found. Add your first car!</p>
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        {{-- Pagination --}}
        @if($cars->hasPages())
            <div class="px-6 py-4 border-t border-slate-200">
                {{ $cars->links() }}
            </div>
        @endif
    </div>
</div>
