<div class="space-y-6">
    {{-- Header --}}
    <div class="flex items-center justify-between">
        <div>
            <a href="{{ route('admin.cars.index') }}" class="text-sm text-slate-500 hover:text-slate-700 mb-2 inline-flex items-center">
                <i class="fa-solid fa-arrow-left mr-2"></i> Back to Cars
            </a>
            <h2 class="text-2xl font-bold tracking-tight text-slate-800">Add New Car</h2>
        </div>
    </div>

    {{-- Form --}}
    <form wire:submit="save" class="bg-white rounded-xl border border-slate-200 shadow-sm overflow-hidden">
        <div class="p-6 space-y-6">
            {{-- Basic Info --}}
            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                <div class="md:col-span-2">
                    <label class="block text-sm font-medium text-slate-700 mb-1.5">Car Name *</label>
                    <div class="relative">
                        <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                            <i class="fa-solid fa-car text-slate-400"></i>
                        </div>
                        <input type="text" wire:model="name" class="block w-full rounded-lg border-0 py-2.5 pl-10 text-slate-900 ring-1 ring-inset ring-slate-300 placeholder:text-slate-400 focus:ring-2 focus:ring-inset focus:ring-[#dc8034] sm:text-sm sm:leading-6" placeholder="e.g. Toyota Avanza 2023">
                    </div>
                    @error('name') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-slate-700 mb-1.5">Brand *</label>
                    <div class="relative">
                        <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                            <i class="fa-solid fa-tag text-slate-400"></i>
                        </div>
                        <select wire:model="brand_id" class="block w-full rounded-lg border-0 py-2.5 pl-10 text-slate-900 ring-1 ring-inset ring-slate-300 placeholder:text-slate-400 focus:ring-2 focus:ring-inset focus:ring-[#dc8034] sm:text-sm sm:leading-6">
                            <option value="">Select Brand</option>
                            @foreach($brands as $brand)
                                <option value="{{ $brand->id }}">{{ $brand->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    @error('brand_id') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-slate-700 mb-1.5">Year *</label>
                    <div class="relative">
                        <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                            <i class="fa-solid fa-calendar text-slate-400"></i>
                        </div>
                        <input type="number" wire:model="year" class="block w-full rounded-lg border-0 py-2.5 pl-10 text-slate-900 ring-1 ring-inset ring-slate-300 placeholder:text-slate-400 focus:ring-2 focus:ring-inset focus:ring-[#dc8034] sm:text-sm sm:leading-6" placeholder="2023">
                    </div>
                    @error('year') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-slate-700 mb-1.5">Seats *</label>
                    <div class="relative">
                        <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                            <i class="fa-solid fa-users text-slate-400"></i>
                        </div>
                        <input type="number" wire:model="seats" class="block w-full rounded-lg border-0 py-2.5 pl-10 text-slate-900 ring-1 ring-inset ring-slate-300 placeholder:text-slate-400 focus:ring-2 focus:ring-inset focus:ring-[#dc8034] sm:text-sm sm:leading-6" placeholder="4">
                    </div>
                    @error('seats') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-slate-700 mb-1.5">Transmission *</label>
                     <div class="relative">
                        <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                            <i class="fa-solid fa-gears text-slate-400"></i>
                        </div>
                        <select wire:model="transmission" class="block w-full rounded-lg border-0 py-2.5 pl-10 text-slate-900 ring-1 ring-inset ring-slate-300 placeholder:text-slate-400 focus:ring-2 focus:ring-inset focus:ring-[#dc8034] sm:text-sm sm:leading-6">
                            <option value="Automatic">Automatic</option>
                            <option value="Manual">Manual</option>
                        </select>
                    </div>
                    @error('transmission') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-slate-700 mb-1.5">Fuel Type *</label>
                     <div class="relative">
                        <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                            <i class="fa-solid fa-gas-pump text-slate-400"></i>
                        </div>
                        <select wire:model="fuel_type" class="block w-full rounded-lg border-0 py-2.5 pl-10 text-slate-900 ring-1 ring-inset ring-slate-300 placeholder:text-slate-400 focus:ring-2 focus:ring-inset focus:ring-[#dc8034] sm:text-sm sm:leading-6">
                            <option value="Petrol">Petrol</option>
                            <option value="Diesel">Diesel</option>
                            <option value="Electric">Electric</option>
                            <option value="Hybrid">Hybrid</option>
                        </select>
                    </div>
                    @error('fuel_type') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                </div>

                <div>
                    <label class="block text-sm font-medium text-slate-700 mb-1.5">Status *</label>
                     <div class="relative">
                        <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                            <i class="fa-solid fa-circle-info text-slate-400"></i>
                        </div>
                        <select wire:model="status" class="block w-full rounded-lg border-0 py-2.5 pl-10 text-slate-900 ring-1 ring-inset ring-slate-300 placeholder:text-slate-400 focus:ring-2 focus:ring-inset focus:ring-[#dc8034] sm:text-sm sm:leading-6">
                            <option value="available">Available</option>
                            <option value="booked">Booked</option>
                            <option value="maintenance">Maintenance</option>
                        </select>
                    </div>
                    @error('status') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                </div>
            </div>

            {{-- Description --}}
            <div>
                <label class="block text-sm font-medium text-slate-700 mb-1.5">Description *</label>
                 <div class="relative">
                    <div class="absolute top-3 left-3 pointer-events-none">
                        <i class="fa-solid fa-align-left text-slate-400"></i>
                    </div>
                    <textarea wire:model="description" rows="3" class="block w-full rounded-lg border-0 py-2.5 pl-10 text-slate-900 ring-1 ring-inset ring-slate-300 placeholder:text-slate-400 focus:ring-2 focus:ring-inset focus:ring-[#dc8034] sm:text-sm sm:leading-6" placeholder="Describe the car features..."></textarea>
                </div>
                @error('description') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
            </div>

            {{-- Pricing --}}
            <div class="border-t border-slate-100 pt-6">
                <h3 class="text-lg font-semibold text-slate-800 mb-4">Pricing</h3>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                    <div>
                        <label class="block text-sm font-medium text-slate-700 mb-1.5">Daily Price (Rp) *</label>
                         <div class="relative">
                             <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                                <span class="text-slate-400 font-semibold text-xs">Rp</span>
                            </div>
                            <input type="number" wire:model="price_daily" class="block w-full rounded-lg border-0 py-2.5 pl-10 text-slate-900 ring-1 ring-inset ring-slate-300 placeholder:text-slate-400 focus:ring-2 focus:ring-inset focus:ring-[#dc8034] sm:text-sm sm:leading-6" placeholder="500000">
                        </div>
                        @error('price_daily') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-slate-700 mb-1.5">Weekly Price (Rp)</label>
                         <div class="relative">
                             <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                                <span class="text-slate-400 font-semibold text-xs">Rp</span>
                            </div>
                            <input type="number" wire:model="price_weekly" class="block w-full rounded-lg border-0 py-2.5 pl-10 text-slate-900 ring-1 ring-inset ring-slate-300 placeholder:text-slate-400 focus:ring-2 focus:ring-inset focus:ring-[#dc8034] sm:text-sm sm:leading-6" placeholder="3000000">
                        </div>
                        @error('price_weekly') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-slate-700 mb-1.5">Monthly Price (Rp)</label>
                         <div class="relative">
                             <div class="absolute inset-y-0 left-0 flex items-center pl-3 pointer-events-none">
                                <span class="text-slate-400 font-semibold text-xs">Rp</span>
                            </div>
                            <input type="number" wire:model="price_monthly" class="block w-full rounded-lg border-0 py-2.5 pl-10 text-slate-900 ring-1 ring-inset ring-slate-300 placeholder:text-slate-400 focus:ring-2 focus:ring-inset focus:ring-[#dc8034] sm:text-sm sm:leading-6" placeholder="10000000">
                        </div>
                        @error('price_monthly') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                    </div>
                </div>
            </div>

            {{-- Image Upload --}}
            <div class="border-t border-slate-100 pt-6">
                <h3 class="text-lg font-semibold text-slate-800 mb-4">Main Image</h3>
                <div class="flex flex-col items-start gap-4">
                     <div class="relative group w-full max-w-[240px] aspect-video bg-slate-50 rounded-xl border-2 border-dashed border-slate-300 hover:border-[#dc8034] hover:bg-[#dc8034]/5 transition-all duration-300 flex flex-col items-center justify-center cursor-pointer overflow-hidden">
                        @if($main_image)
                            <img src="{{ $main_image->temporaryUrl() }}" class="absolute inset-0 w-full h-full object-cover p-2 rounded-xl z-10">
                            <div class="absolute inset-0 bg-black/50 opacity-0 group-hover:opacity-100 transition-opacity z-20 flex items-center justify-center">
                                <span class="text-white font-medium text-sm">Click to Change</span>
                            </div>
                        @else
                            <div class="flex flex-col items-center justify-center p-6 text-center z-10">
                                <div class="w-12 h-12 rounded-full bg-slate-100 flex items-center justify-center mb-3">
                                    <i class="fa-solid fa-cloud-arrow-up text-slate-400 text-xl group-hover:text-[#dc8034] transition-colors"></i>
                                </div>
                                <p class="text-sm font-medium text-slate-700">Click to upload image</p>
                                <p class="text-xs text-slate-500 mt-1">PNG, JPG up to 2MB</p>
                            </div>
                        @endif
                        
                        <input type="file" wire:model="main_image" accept="image/*" class="absolute inset-0 w-full h-full opacity-0 cursor-pointer z-30">
                        
                         {{-- Loading --}}
                        <div wire:loading wire:target="main_image" class="absolute inset-0 bg-white/90 z-40 flex items-center justify-center">
                            <div class="flex flex-col items-center">
                                <i class="fa-solid fa-spinner fa-spin text-2xl text-[#dc8034] mb-2"></i>
                                <span class="text-xs font-semibold text-[#dc8034]">Uploading...</span>
                            </div>
                        </div>
                    </div>
                     @error('main_image') <span class="text-red-500 text-xs mt-1">{{ $message }}</span> @enderror
                </div>
            </div>

            {{-- Gallery Images --}}
            <div class="border-t border-slate-100 pt-6">
                <h3 class="text-lg font-semibold text-slate-800 mb-4">Gallery Images</h3>
                <div class="space-y-4">
                    <div class="relative group w-full min-h-[120px] bg-slate-50 rounded-xl border-2 border-dashed border-slate-300 hover:border-[#dc8034] hover:bg-[#dc8034]/5 transition-all duration-300 flex flex-col items-center justify-center cursor-pointer">
                        <div class="flex flex-col items-center justify-center p-6 text-center">
                            <i class="fa-solid fa-images text-slate-400 text-2xl mb-2 group-hover:text-[#dc8034] transition-colors"></i>
                            <p class="text-sm font-medium text-slate-700">Drop additional images here</p>
                            <p class="text-xs text-slate-500 mt-1">Upload multiple images for the gallery</p>
                        </div>
                        <input type="file" wire:model="images" multiple accept="image/*" class="absolute inset-0 w-full h-full opacity-0 cursor-pointer z-10">
                        
                         {{-- Loading --}}
                        <div wire:loading wire:target="images" class="absolute inset-0 bg-white/90 z-20 flex items-center justify-center rounded-xl">
                            <div class="flex items-center gap-2">
                                <i class="fa-solid fa-spinner fa-spin text-[#dc8034]"></i>
                                <span class="text-xs font-semibold text-[#dc8034]">Processing...</span>
                            </div>
                        </div>
                    </div>
                    @error('images.*') <span class="text-red-500 text-xs">{{ $message }}</span> @enderror

                    {{-- Previews --}}
                    @if($images)
                        <div class="grid grid-cols-2 md:grid-cols-4 lg:grid-cols-6 gap-4">
                            @foreach($images as $image)
                                <div class="relative aspect-video bg-slate-100 rounded-lg overflow-hidden border border-slate-200">
                                    <img src="{{ $image->temporaryUrl() }}" class="w-full h-full object-cover">
                                </div>
                            @endforeach
                        </div>
                    @endif
                </div>
            </div>
        </div>

        {{-- Footer --}}
        <div class="px-6 py-4 bg-slate-50 border-t border-slate-200 flex justify-end gap-3">
            <a href="{{ route('admin.cars.index') }}" class="px-4 py-2 border border-slate-300 text-slate-700 rounded-lg hover:bg-slate-100 transition-colors">
                Cancel
            </a>
            <button type="submit" class="px-6 py-2 bg-[#dc8034] text-white font-semibold rounded-lg hover:bg-[#c06d28] transition-colors shadow-lg shadow-[#dc8034]/20">
                <i class="fa-solid fa-save mr-2"></i> Save Car
            </button>
        </div>
    </form>
</div>
