
{{-- Dashboard --}}
<a href="{{ route('admin.dashboard') }}" 
   class="flex items-center px-3 py-2.5 text-sm font-medium rounded-md transition-colors group {{ request()->routeIs('admin.dashboard') ? 'bg-[#dc8034] text-white' : 'text-slate-300 hover:bg-slate-800 hover:text-white' }}">
    <i class="fa-solid fa-house w-5 h-5 mr-3 {{ request()->routeIs('admin.dashboard') ? 'text-white' : 'text-slate-400 group-hover:text-white' }}"></i>
    Dashboard
</a>

<div class="my-4 border-t border-slate-700/50"></div>

{{-- Management --}}
<p class="px-3 text-xs font-semibold text-slate-500 uppercase tracking-wider mb-2">Management</p>

<a href="{{ route('admin.cars.index') }}"
   class="flex items-center px-3 py-2.5 text-sm font-medium rounded-md transition-colors group {{ request()->routeIs('admin.cars.*') ? 'bg-[#dc8034] text-white' : 'text-slate-300 hover:bg-slate-800 hover:text-white' }}">
    <i class="fa-solid fa-car w-5 h-5 mr-3 {{ request()->routeIs('admin.cars.*') ? 'text-white' : 'text-slate-400 group-hover:text-white' }}"></i>
    Cars
</a>


<a href="{{ route('admin.motors.index') }}"
   class="flex items-center px-3 py-2.5 text-sm font-medium rounded-md transition-colors group {{ request()->routeIs('admin.motors.*') ? 'bg-[#dc8034] text-white' : 'text-slate-300 hover:bg-slate-800 hover:text-white' }}">
    <i class="fa-solid fa-motorcycle w-5 h-5 mr-3 {{ request()->routeIs('admin.motors.*') ? 'text-white' : 'text-slate-400 group-hover:text-white' }}"></i>
    Motorbikes
</a>


<a href="{{ route('admin.tours.index') }}"
   class="flex items-center px-3 py-2.5 text-sm font-medium rounded-md transition-colors group {{ request()->routeIs('admin.tours.*') ? 'bg-[#dc8034] text-white' : 'text-slate-300 hover:bg-slate-800 hover:text-white' }}">
    <i class="fa-solid fa-map w-5 h-5 mr-3 {{ request()->routeIs('admin.tours.*') ? 'text-white' : 'text-slate-400 group-hover:text-white' }}"></i>
    Tours
</a>

<a href="{{ route('admin.brands') }}"
   class="flex items-center px-3 py-2.5 text-sm font-medium rounded-md transition-colors group {{ request()->routeIs('admin.brands') ? 'bg-[#dc8034] text-white' : 'text-slate-300 hover:bg-slate-800 hover:text-white' }}">
    <i class="fa-solid fa-tags w-5 h-5 mr-3 {{ request()->routeIs('admin.brands') ? 'text-white' : 'text-slate-400 group-hover:text-white' }}"></i>
    Brands
</a>

<a href="{{ route('admin.articles.index') }}"
   class="flex items-center px-3 py-2.5 text-sm font-medium rounded-md transition-colors group {{ request()->routeIs('admin.articles.*') ? 'bg-[#dc8034] text-white' : 'text-slate-300 hover:bg-slate-800 hover:text-white' }}">
    <i class="fa-solid fa-newspaper w-5 h-5 mr-3 {{ request()->routeIs('admin.articles.*') ? 'text-white' : 'text-slate-400 group-hover:text-white' }}"></i>
    Articles
</a>


{{-- Superadmin Only --}}
@if(auth()->user()->isSuperadmin())
    <div class="my-4 border-t border-slate-700/50"></div>
    <p class="px-3 text-xs font-semibold text-slate-500 uppercase tracking-wider mb-2">System</p>

    <a href="{{ route('admin.settings') }}" 
       class="flex items-center px-3 py-2.5 text-sm font-medium rounded-md transition-colors group {{ request()->routeIs('admin.settings') ? 'bg-[#dc8034] text-white' : 'text-slate-300 hover:bg-slate-800 hover:text-white' }}">
        <i class="fa-solid fa-gear w-5 h-5 mr-3 {{ request()->routeIs('admin.settings') ? 'text-white' : 'text-slate-400 group-hover:text-white' }}"></i>
        Settings
    </a>
    
    <a href="{{ route('admin.users.index') }}" class="flex items-center px-3 py-2.5 text-sm font-medium rounded-md transition-colors group {{ request()->routeIs('admin.users.*') ? 'bg-[#dc8034] text-white' : 'text-slate-300 hover:bg-slate-800 hover:text-white' }}">
         <i class="fa-solid fa-users w-5 h-5 mr-3 {{ request()->routeIs('admin.users.*') ? 'text-white' : 'text-slate-400 group-hover:text-white' }}"></i>
        Users
    </a>
@endif
