<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Setting;

class SettingsSeeder extends Seeder
{
    public function run(): void
    {
        $settings = [
            ['key' => 'enable_cars', 'value' => '1', 'description' => 'Enable Car Rental Module'],
            ['key' => 'enable_motors', 'value' => '1', 'description' => 'Enable Motor Rental Module'],
            ['key' => 'enable_tours', 'value' => '1', 'description' => 'Enable Tour Module'],
            ['key' => 'whatsapp_number', 'value' => '6281234567890', 'description' => 'Default WhatsApp Number'],
            ['key' => 'hero_title', 'value' => 'Explore Bali with Freedom', 'description' => 'Hero Section Title'],
            [
                'key' => 'hero_slides',
                'value' => json_encode([
                    [
                        'image' => 'https://images.unsplash.com/photo-1537996194471-e657df975ab4?auto=format&fit=crop&q=80',
                        'title' => 'Explore Bali with Freedom',
                        'subtitle' => 'Experience the ultimate freedom of exploring Bali at your own pace. With our premium fleet of well-maintained motorbikes and cars, your perfect island getaway starts the moment you turn the key.',
                    ],
                    [
                        'image' => 'https://images.unsplash.com/photo-1552083375-1447ce886485?auto=format&fit=crop&q=80',
                        'title' => 'Unforgettable Tours',
                        'subtitle' => 'Immerse yourself in the authentic culture and breathtaking landscapes of Bali. Our expertly curated tours take you beyond the beaten path to discover hidden gems and create lasting memories.',
                    ]
                ]),
                'description' => 'Hero Slides Data'
            ],
        ];

        foreach ($settings as $setting) {
            Setting::updateOrCreate(['key' => $setting['key']], $setting);
        }
    }
}
