<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('cars', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->text('description');
            $table->foreignId('brand_id')->constrained('car_brands')->onDelete('cascade');
            $table->integer('year');
            $table->integer('seats')->default(4);
            $table->string('transmission'); // Automatic/Manual
            $table->string('fuel_type');
            $table->decimal('price_daily', 12, 2);
            $table->decimal('price_weekly', 12, 2)->nullable();
            $table->decimal('price_monthly', 12, 2)->nullable();
            $table->string('main_image');
            $table->json('images')->nullable(); // Gallery
            $table->string('status')->default('available');
            $table->json('features')->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('cars');
    }
};
