<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use App\Models\MotorBrand;

class MotorFactory extends Factory
{
    public function definition(): array
    {
        return [
            'name' => $this->faker->word() . ' ' . $this->faker->numberBetween(110, 250),
            'description' => $this->faker->paragraph(),
            'brand_id' => MotorBrand::inRandomOrder()->first()->id ?? MotorBrand::factory(),
            'cc' => $this->faker->randomElement([110, 125, 150, 250]),
            'transmission' => $this->faker->randomElement(['Automatic', 'Manual']),
            'fuel_type' => 'Petrol',
            'price_daily' => $this->faker->numberBetween(50000, 150000),
            'price_weekly' => $this->faker->numberBetween(300000, 900000),
            'price_monthly' => $this->faker->numberBetween(1000000, 2500000),
            'main_image' => 'https://images.unsplash.com/photo-1558981806-ec527fa84f3d?auto=format&fit=crop&q=80',
            'status' => 'available',
        ];
    }
}
