<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use App\Models\CarBrand;

class CarFactory extends Factory
{
    public function definition(): array
    {
        return [
            'name' => $this->faker->word() . ' ' . $this->faker->year(),
            'description' => $this->faker->paragraph(),
            'brand_id' => CarBrand::inRandomOrder()->first()->id ?? CarBrand::factory(),
            'year' => $this->faker->year(),
            'seats' => $this->faker->randomElement([4, 6, 7]),
            'transmission' => $this->faker->randomElement(['Automatic', 'Manual']),
            'fuel_type' => $this->faker->randomElement(['Petrol', 'Diesel']),
            'price_daily' => $this->faker->numberBetween(250000, 800000),
            'price_weekly' => $this->faker->numberBetween(1500000, 5000000),
            'price_monthly' => $this->faker->numberBetween(5000000, 15000000),
            'main_image' => 'https://images.unsplash.com/photo-1549317661-bd32c8ce0db2?auto=format&fit=crop&q=80',
            'status' => 'available',
        ];
    }
}
