<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Tour extends Model
{
    use HasFactory;

    protected $guarded = ['id'];

    protected $casts = [
        'images' => 'array',
        'highlights' => 'array',
        'includes' => 'array',
        'excludes' => 'array',
        'itinerary' => 'array',
        'price' => 'decimal:2',
        'price_motor' => 'decimal:2',
    ];

    public function bookings()
    {
        return $this->hasMany(TourBooking::class);
    }
}
