<?php

namespace App\Livewire\Tours;

use App\Models\Tour;
use Livewire\Component;
use Livewire\Attributes\Layout;

#[Layout('layouts.app')]
class Show extends Component
{
    public Tour $tour;

    public $bookingName = '';
    public $bookingDate = '';
    public $bookingPax = 2;
    public $whatsappNumber;

    public function mount(Tour $tour)
    {
        $this->tour = $tour;
        $this->whatsappNumber = \App\Models\Setting::where('key', 'whatsapp_number')->value('value') ?? '6281234567890';
    }

    public function submitBooking()
    {
        $this->validate([
            'bookingName' => 'required|string|max:255',
            'bookingDate' => 'required|date',
            'bookingPax' => 'required|numeric|min:1',
        ]);

        // Log the activity
        \App\Models\ActivityLog::create([
            'ip_address' => request()->ip(),
            'user_agent' => request()->userAgent(),
            'user_id' => auth()->id(),
            'action' => 'booking_submission',
            'description' => "Booking Request for Tour: {$this->tour->name}",
            'details' => [
                'item_type' => 'tour',
                'item_id' => $this->tour->id,
                'item_name' => $this->tour->name,
                'customer_name' => $this->bookingName,
                'booking_date' => $this->bookingDate,
                'pax' => $this->bookingPax,
            ],
            'url' => request()->fullUrl(),
        ]);

        // Construct WhatsApp Message
        $text = "Hello! I would like to book Tour: *{$this->tour->name}*.\n\n" .
                "Name: {$this->bookingName}\n" .
                "Date: {$this->bookingDate}\n" .
                "Pax: {$this->bookingPax} People";
        
        $url = "https://wa.me/{$this->whatsappNumber}?text=" . urlencode($text);

        $this->dispatch('open-whatsapp', url: $url);
    }

    public function render()
    {
        return view('livewire.tours.show');
    }
}
