<?php

namespace App\Livewire\Components;

use App\Models\CarBrand;
use App\Models\MotorBrand;
use Livewire\Component;

class SearchPanel extends Component
{
    public $vehicleType = 'car';
    public $brands = [];
    public $selectedBrand = '';
    public $selectedTransmission = '';

    public function mount()
    {
        $this->updateBrands();
    }

    public function updatedVehicleType()
    {
        $this->updateBrands();
        $this->selectedBrand = '';
    }

    public function updateBrands()
    {
        if ($this->vehicleType === 'car') {
            $this->brands = CarBrand::orderBy('name')->get();
        } else {
            $this->brands = MotorBrand::orderBy('name')->get();
        }
    }

    public function search()
    {
        $route = $this->vehicleType === 'car' ? 'cars.index' : 'motors.index';
        $params = [];
        
        if ($this->selectedBrand) {
            $params['brand'] = $this->selectedBrand;
        }
        
        if ($this->selectedTransmission) {
            $params['transmission'] = $this->selectedTransmission;
        }

        return redirect()->route($route, $params);
    }

    public function render()
    {
        return view('livewire.components.search-panel');
    }
}
