<?php

namespace App\Livewire\Components;

use Livewire\Component;
use App\Models\Setting;

class Hero extends Component
{
    public $slides = [];
    public $whatsappNumber;

    public function mount()
    {
        $this->whatsappNumber = Setting::where('key', 'whatsapp_number')->value('value') ?? '6281234567890';
        
        $slidesJson = Setting::where('key', 'hero_slides')->value('value');
        $this->slides = $slidesJson ? json_decode($slidesJson, true) : [];

        if (empty($this->slides)) {
            $this->slides = [
                [
                    'image' => 'https://images.unsplash.com/photo-1537996194471-e657df975ab4?auto=format&fit=crop&q=80',
                    'title' => 'Explore Bali with Freedom',
                    'subtitle' => 'Experience the ultimate freedom of exploring Bali at your own pace. With our premium fleet of well-maintained motorbikes and cars, your perfect island getaway starts the moment you turn the key.',
                ],
                [
                    'image' => 'https://images.unsplash.com/photo-1552083375-1447ce886485?auto=format&fit=crop&q=80',
                    'title' => 'Unforgettable Tours',
                    'subtitle' => 'Immerse yourself in the authentic culture and breathtaking landscapes of Bali. Our expertly curated tours take you beyond the beaten path to discover hidden gems and create lasting memories.',
                ],
            ];
        }
    }

    public function render()
    {
        return view('livewire.components.hero');
    }
}
