<?php

namespace App\Livewire\Admin\Tours;

use App\Models\Tour;
use Livewire\Component;
use Livewire\WithFileUploads;

class Edit extends Component
{
    use WithFileUploads;

    public Tour $tour;

    public $name;
    public $description;
    public $duration;
    public $price;
    public $price_motor;
    public $new_main_image;
    public $images = []; // Existing gallery
    public $new_images = []; // New uploads
    public $category;
    public $difficulty;
    public $max_people;
    public $status;

    public function mount(Tour $tour)
    {
        $this->tour = $tour;
        $this->name = $tour->name;
        $this->description = $tour->description;
        $this->duration = $tour->duration;
        $this->price = $tour->price;
        $this->price_motor = $tour->price_motor;
        $this->category = $tour->category;
        $this->difficulty = $tour->difficulty;
        $this->max_people = $tour->max_people;
        $this->images = $tour->images ?? [];
        $this->status = $tour->status;
    }

    public function rules()
    {
        return [
            'name' => 'required|string|max:255',
            'description' => 'required|string',
            'duration' => 'required|string',
            'price' => 'required|numeric|min:0',
            'price_motor' => 'nullable|numeric|min:0',
            'new_main_image' => 'nullable|image|max:10240',
            'new_images.*' => 'image|max:10240',
            'category' => 'required|string',
            'difficulty' => 'required|in:Easy,Medium,Hard',
            'max_people' => 'required|integer|min:1',
            'status' => 'required|in:active,inactive',
        ];
    }

    public function removeImage($index)
    {
        if (isset($this->images[$index])) {
            unset($this->images[$index]);
            $this->images = array_values($this->images); // Reindex
        }
    }

    public function save()
    {
        $validatedData = $this->validate();

        if ($this->new_main_image) {
            $validatedData['main_image'] = $this->new_main_image->store('tours', 'public');
        } else {
            $validatedData['main_image'] = $this->tour->main_image;
        }

        // Handle Gallery
        $currentImages = $this->images; // Start with existing (after deletions)
        
        if ($this->new_images) {
            foreach ($this->new_images as $image) {
                $currentImages[] = $image->store('tours/gallery', 'public');
            }
        }
        
        $validatedData['images'] = $currentImages;

        unset($validatedData['new_main_image']);
        unset($validatedData['new_images']);

        $this->tour->update($validatedData);

        session()->flash('success', 'Tour package updated successfully.');

        return redirect()->route('admin.tours.index');
    }

    public function render()
    {
        return view('livewire.admin.tours.edit')->layout('layouts.admin');
    }
}
