<?php

namespace App\Livewire\Admin\Articles;

use App\Models\Article;
use Livewire\Component;
use Livewire\WithPagination;
use Livewire\Attributes\Layout;

#[Layout('layouts.admin')]
class Index extends Component
{
    use WithPagination;

    public $search = '';

    public function delete($id)
    {
        $article = Article::find($id);
        if ($article) {
            $article->delete();
            session()->flash('success', 'Article deleted successfully.');
        }
    }

    public function render()
    {
        $articles = Article::query()
            ->when($this->search, function ($query) {
                $query->where('title', 'like', '%' . $this->search . '%');
            })
            ->latest()
            ->paginate(10);

        return view('livewire.admin.articles.index', [
            'articles' => $articles
        ]);
    }
}
