<?php

namespace App\Http\Controllers;

use App\Models\ActivityLog;
use Illuminate\Http\Request;

class TrackingController extends Controller
{
    public function trackClick(Request $request)
    {
        $url = $request->query('url');
        $type = $request->query('type', 'generic_click');

        if (!$url) {
            return redirect('/');
        }

        ActivityLog::create([
            'ip_address' => $request->ip(),
            'user_agent' => $request->userAgent(),
            'user_id' => auth()->id(),
            'action' => $type,
            'description' => "Clicked {$type} link",
            'url' => $request->fullUrl(),
            'details' => ['target_url' => $url],
        ]);

        return redirect()->away($url);
    }
}
